/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package concurrentCollections;

import java.util.Queue;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Producer implements Runnable {
    
    Queue q;//The queue we will be producing for.
    
    public Producer(Queue q){
        //set the queue that we will be writing to
        this.q=q;
    }
    
    //Produce the numbers from 1 to 10 putting them on the queue.
    @Override
    public void run(){
        for (int i=1;i<=10;i++){
            q.add(i);
            //Have a break for a bit
            try{
                Thread.sleep(10);
            } catch (InterruptedException ex) {
                System.out.println(Thread.currentThread().getName()+" was interrupted.");
            }
        }
    }
}
